# ERP Table Scraper - Simple Chrome Extension

This small extension injects a floating control panel into pages and scrapes tabular attendance data (like the ERP screenshot you shared) into a CSV file.

Features:
- Finds a table containing columns like Aadhaar/Name/Attendance and extracts rows
- Attempts to collect nearby meta information (Course, Subject, Batch, Period, Semester, Date)
- Shows an animated Refresh button to re-scan the page
- One-click Download CSV (handled by background worker)
- No toolbar icon required (manifest has empty icons)

Files:
- `manifest.json` - extension manifest (MV3)
- `background.js` - service worker to start downloads
- `content_script.js` - injected UI and scraper logic
- `styles.css` - styling for the panel

How to load locally (Chrome / Edge):
1. Open chrome://extensions (or edge://extensions).
2. Enable "Developer mode".
3. Click "Load unpacked" and select the `hudatascaper` folder. Alternatively you can download the packaged ZIP from `index.html` and unzip it, then load the unzipped folder.
4. Open your ERP page, wait ~1s, and you'll see a floating "ERP Scraper" panel.

Usage:
- "Refresh & Start" — triggers a small animation and rescans the page (use this after changing course/selection on the ERP page).
- "Scrape Now" — extracts the table visible on the page and updates the counter.
- "Download CSV" — downloads the last scraped CSV as `erp-scrape-<timestamp>.csv`.
	- Filename now attempts to include course/batch/group/semester when available (e.g. `BTech_CSE_GroupC_2024-28_Sem3_2025-11-07T10-00-55.csv`).
	- Serial numbers (Sr. No) in the CSV are now sequential (1..N) to avoid incorrect values copied from hidden fields.

Notes & Caveats:
- The scraper finds the first table that contains "Aadhaar" and "Attendance" or "Sr. No" and "Name". If your portal uses non-standard markup, it may need tweaks.
- If the page loads data dynamically, use the Refresh button after you change selections to let the page update before scraping.
- The extension requests minimal permissions: activeTab, scripting, downloads.
- The extension has a popup that checks the current tab: if the tab doesn't look like your ERP host the popup shows a privacy shield message explaining the extension will not run on that site. The popup also provides an "Open ERP site" button — replace the URL in `popup.js` with your actual ERP URL if needed.

Next steps (optional):
- Add a small options page to configure filename format or which columns to pick.
- Add better heuristics for tables spread across multiple nested elements.
