// Background service worker: listens for download requests from content script
chrome.runtime.onMessage.addListener((msg, sender) => {
  if (msg && msg.type === 'download') {
    try {
      // Use a data URL since object URLs in service workers can be problematic in some browsers
      const csv = msg.data;
      const dataUrl = 'data:text/csv;charset=utf-8,' + encodeURIComponent(csv);
      chrome.downloads.download({ url: dataUrl, filename: msg.filename || 'data.csv' }, (id) => {
        if (chrome.runtime.lastError) console.error('Download error:', chrome.runtime.lastError.message);
      });
    } catch (err) {
      console.error('Download failed', err);
    }
  }
});
