document.addEventListener('DOMContentLoaded', async () => {
  const content = document.getElementById('content');
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  const url = tab && tab.url || '';
  // Stricter domain whitelist stored in chrome.storage
  try {
    const u = new URL(url);
    const host = u.hostname;
    const allowRow = document.getElementById('allow-row');
    const allowCheckbox = document.getElementById('allow-site');
    const stored = await chrome.storage.local.get({ allowedHosts: [] });
    const allowed = stored.allowedHosts || [];
    const isAllowed = allowed.includes(host);
    if (isAllowed) {
      content.innerHTML = '<div class="ok">Allowed ERP host: ' + host + '</div>';
    } else {
      content.innerHTML = '<div class="warn">Not an allowed ERP host: ' + host + '</div>';
      allowRow.style.display = 'block';
    }
    allowCheckbox.checked = isAllowed;
    allowCheckbox.addEventListener('change', async (e) => {
      let allowedHosts = (await chrome.storage.local.get({ allowedHosts: [] })).allowedHosts || [];
      if (e.target.checked) {
        if (!allowedHosts.includes(host)) allowedHosts.push(host);
      } else {
        allowedHosts = allowedHosts.filter(h => h !== host);
      }
      await chrome.storage.local.set({ allowedHosts });
      // refresh content
      if (e.target.checked) content.innerHTML = '<div class="ok">Allowed ERP host: ' + host + '</div>';
      else { content.innerHTML = '<div class="warn">Not an allowed ERP host: ' + host + '</div>'; allowRow.style.display = 'block'; }
    });
  } catch (e) { content.textContent = 'No active tab'; }

  document.getElementById('open-erp').addEventListener('click', () => {
    chrome.tabs.create({ url: 'http://localhost/erp' });
  });
});
